
#include <stdio.h>
#include <tchar.h>
//#include <regex>

#include "OnScreenDisplay.h"
#include "cpcemu.h"
#include "../../cpc_modified/cheatdb.h"
#include "ifacegen.h"
#include "../../cpc/cpc.h"

void DrawBox(HDC hdc, int x, int y,int w,int h,COLORREF c1,COLORREF c2);
void DrawRect(HDC hdc, int x, int y,int w,int h);
int GetLenghtText(HDC hdc,char*s);
BOOL loadThumb();
void DrawThumb(HDC hdc);

#define NBREMENU 10
#define MENUHEIGHT 32
#define MAXSNAP 3
#define CROCH(s,b) (b?"<"#s">":#s)
#define MENUX 150
#define MENUY 100

//Disk A Name
extern TCHAR DriveAFilename[MAX_PATH];
//Last opened rom
extern TCHAR LastOpenedRom[MAX_PATH];

//from cpcemu.c
void ExternCommand(int command,int data);
void GetRealZone(RECT * rc);
void GetThumbfile(char *name,int num);
void GetDiskNumberInfo(int *number,int *max);

//thumb handle
HBITMAP bmpthumb=NULL;

//message
static int timing = 0;
char Texte[255];

//menu
BOOL OnScreenMenu = FALSE;
short SelMenu = 0;
short SelKey = 0;
short SelSnap = 0;
short SelDisk;
int TempoMenu;
int MaxDisk;
int CurDisk;

extern POKEGAMEINFO pgi;
int IDGame;
int NbreCheat;

extern APP_DATA AppData;

void ManageCheat(void);

//menu
static TCHAR *MenuText[]=
{
	_T("Resume"),
	_T("Change disk (1/1)"),
	_T("Reset"),
	_T("Take screenshoot"),
	_T("Simulate Key : A B < C > D E"),
	_T("Save snapshoot :  0  1  2  3"),
	_T("Load snapshoot :  0  1  2  3"),
	_T("Restart in 6128 Normal"),
	_T("Cheat"),
	_T("Exit emulator"),
	NULL
};
const TCHAR *SimKey[] = {"ESC","SPC","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","0","1","2","3","4","5","6","7","8","9","F1","F2","F3","F4","F5","F6","F7","F8","F9","RTRN","ESC","SPC","A","B"};
const int IdAmstradKey[] = {66,47,69,54,62,61,58,53,52,44,35,45,37,36,38,46,34,27,67,50,60,51,42,55,59,63,43,71,32,64,65,57,56,49,48,41,40,33,13,14,5,20,12,4,10,11,3,18,66,47,69,54 };

BOOL SetInfoMessage(char * Message)
{
	strncpy_s(Texte,sizeof(Texte),Message,255);
	Texte[strlen(Message)+1] = '\0';
	timing = 200;
	return TRUE;
}

//extern char DebugText[255];

BOOL DisplayInfoMessage(HDC hdc)
{
	//AfficherTexte(hdc, DebugText, 1, 10, 0, RGB(255, 0, 0), RGB(0, 0, 0));

	if ((timing == 0) || (Texte[0] == '\0') ) return FALSE;
	timing -=1;
	if (timing < 0) {
		timing = 0;
		Texte[0]='\0';
	}

	AfficherTexte(hdc,Texte, 1, 1, 0, RGB(255,0,0), RGB(0,0,0));

	return TRUE;
}

void AfficherTexte(HDC hdc, char* Text, int X, int Y, BOOL Center, DWORD TextColor, DWORD BackColor)
{
	LOGFONT logfont;
	HFONT hFont;
	HFONT hOldFont;
	int len,h;

	RECT rc;
	long opt;
	//TEXTMETRIC tm;
	
	len = strlen(Text);

	if (len == 0) return;

     if (Center)
       opt = DT_CENTER;
     else
       opt = DT_LEFT | DT_TOP;

	 GetRealZone(&rc);
	//https://support.microsoft.com/en-us/kb/74299
	 h = 18;

	 //GetTextMetrics(hdc,&tm);

	 hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	 GetObject(hFont, sizeof(LOGFONT), &logfont);

	 logfont.lfHeight = MulDiv(h, GetDeviceCaps(hdc, LOGPIXELSY), 72);

     logfont.lfWeight = FW_BOLD;
	 hFont = CreateFontIndirect(&logfont);

	 hOldFont = (HFONT)SelectObject(hdc, hFont);
	 
     SetTextColor(hdc,TextColor);
     SetBkColor(hdc,BackColor);

	 rc.top=Y*logfont.lfHeight;
	 //rc.bottom+=Y*logfont.lfHeight;
	 //rc.right+=X*logfont.lfHeight - dec;
	 rc.left=X*logfont.lfHeight;

	 //TextOut(hdc, rc.left + X*logfont.lfHeight - dec, rc.top + Y*logfont.lfHeight, Text, len);
	 DrawText(hdc,Text,len,&rc, opt | DT_EXTERNALLEADING | DT_WORDBREAK);

	 SelectObject(hdc, hOldFont);
	 DeleteObject(hFont);

}

//************************************************************************************
//menu

void ToogleOnScreenMenu(BOOL force)
{
	if (!force)
	{
		TempoMenu +=1;
		if (TempoMenu < 7) return;
		TempoMenu = 0;
	}

	OnScreenMenu = 1 - OnScreenMenu;

	if (OnScreenMenu)
	{
		//Get info about media
		//GetMediaName();

		GetDiskNumberInfo(&CurDisk,&MaxDisk);

/*
		if ( reDisk1.Matches(m_FileName) )
		{
			wxString tmp = reDisk1.GetMatch(m_FileName,2);
			m_CurDisk = wxAtoi(tmp);
			tmp = reDisk1.GetMatch(m_FileName,3);
			m_MaxDisk = wxAtoi(tmp);
		}
*/

		// to avoid error
		if (MaxDisk > 4) MaxDisk = 4;
		if (MaxDisk < 1) MaxDisk = 1;
		if (CurDisk < 1) CurDisk = 1;
		if (CurDisk > MaxDisk) CurDisk = 1;

		IDGame = -2;

		SelMenu = 0;
		TempoMenu = 0;
		SelKey = 2;
		SelSnap = 0;
		SelDisk = CurDisk;
	}

	if (bmpthumb)
	{
		DeleteObject(bmpthumb);
		bmpthumb = NULL;
	}
	loadThumb();
}
void    CPC_ClearKeyboard(void);
BOOL changeMenu(JoyInfoSystem Joy)
{
	int command = 0;
	if (!OnScreenMenu) return FALSE;
	TempoMenu +=1;
	if (TempoMenu < 7) return TRUE;
	TempoMenu = 0;

	//A ameliorer
	if (Joy.x<0) command = 3;
	else if (Joy.x>0) command = 4;
	if (Joy.y<0) command = 1;
	else if (Joy.y>0) command = 2;
	if (Joy.buttons == 0) command = 5;

	if (Joy.buttons == 5)
	{
		ToogleOnScreenMenu(TRUE);
		return TRUE;
	}
	
	switch (command)
	{
		//down
		case 1:
			SelMenu -=1;
			if (SelMenu < 0) SelMenu = NBREMENU - 1;
			break;
		//up
		case 2:
			SelMenu +=1;
			if (SelMenu > NBREMENU - 1) SelMenu = 0;
			break;
		//left
		case 3:
			if ((SelMenu == 5) || (SelMenu == 6))
			{
				SelSnap -=1;
				if (SelSnap < 0) SelSnap = 0;
				loadThumb();
			}
			if (SelMenu == 4)
			{
				SelKey -=1;
				if (SelKey < 2) SelKey = 49;
			}
			if (SelMenu == 1)
			{
				SelDisk -=1;
				if (SelDisk < 1) SelDisk = 1;
			}
			break;
		//right
		case 4:
			if ((SelMenu == 5) || (SelMenu == 6))
			{
				SelSnap +=1;
				if (SelSnap > MAXSNAP) SelSnap = MAXSNAP;
				loadThumb();
			}
			if (SelMenu == 4)
			{
				SelKey +=1;
				if (SelKey > 49) SelKey = 2;
			}
			if (SelMenu == 1)
			{
				SelDisk +=1;
				if (SelDisk > MaxDisk) SelDisk = MaxDisk;
			}
			break;
		//button
		case 5:
			switch (SelMenu)
			{
			case 1:
				ExternCommand(SelMenu,SelDisk);
				break;
			case 4:
				ExternCommand(SelMenu,IdAmstradKey[SelKey]);
				break;
			case 5:
				ExternCommand(SelMenu,SelSnap);
				break;
			case 6:
				ExternCommand(SelMenu,SelSnap);
				break;
			case 8:
				ManageCheat();
				break;
			default:
				ExternCommand(SelMenu,0);
			}
			break;
		default:
			break;
	}
	return TRUE;
}

void ManageCheat(void)
{
	LoadDatabase(CheatFilename);
	IDGame = SearchGameinMemory();
	if (IDGame != -1)
	{
		CheatSetGame(IDGame);
		NbreCheat = pgi.NbrePoke;
	}
}

BOOL loadThumb()
{
	char name[MAX_PATH];
	GetThumbfile(name,SelSnap);
	bmpthumb = (HBITMAP)LoadImage(NULL, name,IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
	if (bmpthumb) return TRUE;

	return FALSE;
}

void DrawThumb(HDC hdc)
{
	HDC MemDC;
	MemDC = CreateCompatibleDC(hdc);
    SelectObject(MemDC, bmpthumb);

	BitBlt(hdc, 2, 2, 150, 150, MemDC, 0, 0, SRCCOPY);

    DeleteDC(MemDC);
}

void DrawLED(HDC hdc)
{
	DrawBox(hdc,10,520,15,15, RGB(255,0,0),RGB(0,0,0));
}

BOOL DisplayMenu(HDC hdc)
{
	int i;
	char tmp[255];

	LOGFONT logfont;
	HFONT hFont;
	HFONT hOldFont;
	int x,y,w,h;
	//int ratio;

	RECT rc;
	RECT ZoneTexte;

	if (!OnScreenMenu) return FALSE;

	//Setting font
	hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
	GetObject(hFont, sizeof(LOGFONT), &logfont);
	logfont.lfHeight = MENUHEIGHT;
	logfont.lfWeight = FW_BOLD;
	hFont = CreateFontIndirect(&logfont);
	hOldFont = (HFONT)SelectObject(hdc, hFont);
	SetTextAlign(hdc, TA_LEFT);

	/*
	if (AppData.Windowed)
	{
		x = AppData.WindowWidth/2;
		y = AppData.WindowHeight/10;
		logfont.lfHeight = AppData.WindowWidth / 20;
		ratio = 1;
	}
	else 
	{
		x = AppData.FullScreenWidth/2;
		y = AppData.FullScreenHeight/10;
		logfont.lfHeight = AppData.FullScreenWidth / 60;
		ratio = 1;
	}
	*/

	GetRealZone(&rc);

	//calcul dimensions ecran
	w = rc.right-rc.left;
	h = rc.bottom-rc.top;
	y = h/10;
	x = logfont.lfHeight * 4;

#if 0
	//calcul ratio deformation
	{
		float rx,ry;
		rx = w / 768.0f;
		ry = h / 544.0f;

		if (rx > ry) ratio = rx;
		else ratio = ry;
	}
#endif

	//affiche fond
	DrawBox(hdc,MENUX + rc.left,MENUY + rc.top,768-2*MENUX,544-2*MENUY+10,RGB(0, 0, 0),RGB(150, 150, 150));

	SetBkColor(hdc,RGB(0,0,0));
	//SetBkMode(hdc, TRANSPARENT);

    //SetTextColor(hdc,RGB(255,0,0));
	
	for (i=0; i < NBREMENU; i++)
	{
		if (i == SelMenu) { SetTextColor(hdc,RGB(68, 117, 229)); }
		else { SetTextColor(hdc,RGB(150, 150, 150)); }
		strncpy_s(tmp,sizeof(tmp),MenuText[i],strlen(MenuText[i]));

		//recuperation zone de texte
		ZoneTexte.left = MENUX + 20;
		ZoneTexte.top = MENUY + 20 + ( i * MENUHEIGHT + 2 );
		ZoneTexte.right = ZoneTexte.left + GetLenghtText(hdc,tmp);
		ZoneTexte.bottom = ZoneTexte.top + MENUHEIGHT ;

		//1 - Chnage disk
		if (i == 1)
		{
			if (MaxDisk == 0)
			{
				sprintf(tmp, "Change disk (No disk in drive A)");
			}
			else
			{
				sprintf(tmp, "Change disk ( %d /%d)",SelDisk,MaxDisk);
			}
		}

		//System changement
		if ( i == 7)
		{
			if (CPC_GetCPCType() == CPC_TYPE_6128PLUS) strncpy(tmp,"Restart in 6128 Normal",254);
			else strncpy(tmp,"Restart in 6128 Plus",254);
		}
		if ( i == 8)
		{
			if (IDGame == -2) strncpy(tmp,"Cheat : (Search)",254);
			else if (IDGame == -1) strncpy(tmp,"Cheat : (Not cheats found)",254);
			else sprintf(tmp, "Cheat : (%d cheats found)",NbreCheat);

		}

		if (i != 4) TextOut(hdc, MENUX +20 + rc.left , MENUY + 20 + ( i * MENUHEIGHT + 2 ) + rc.top ,tmp, strlen(tmp));

		//Key simulation
		if (i == 4)
		{
			int t;
			int l;

			strncpy(tmp,"Send Key :",254);
			for(t = SelKey - 1; t <= SelKey + 1; t++) {

				//tmp.append(" " + wxT(SimKey[t]) + " ");
				//tmp = tmp + " " + SimKey[t] + " ";
				strcat(tmp," ");
				strcat(tmp,SimKey[t]);
				strcat(tmp," ");

				if (t == SelKey - 1)
				{
					ZoneTexte.left += GetLenghtText(hdc,tmp);
				}
				if (t == SelKey)
				{
					char tmp2[255];
					sprintf(tmp2, " ");
					strcat(tmp2,SimKey[SelKey]);
					strcat(tmp2," ");
					//strcat(tmp2,"\0");
					l = GetLenghtText(hdc,tmp2);
				}
			}

			TextOut(hdc, MENUX +20 + rc.left , MENUY + 20 + ( i * MENUHEIGHT + 2 ) + rc.top ,tmp, strlen(tmp));
			DrawRect(hdc,ZoneTexte.left+rc.left,ZoneTexte.top+rc.top,l,MENUHEIGHT);
		}

		//Snaps Save
		if (i == 5)
		{
			ZoneTexte.left += GetLenghtText(hdc,"Save snapshoot :.") + SelSnap * MENUHEIGHT;
			DrawRect(hdc,ZoneTexte.left+rc.left,ZoneTexte.top+rc.top,MENUHEIGHT,MENUHEIGHT);

			//display thumb in a corner
			if ((SelMenu == 5) && (bmpthumb))
			{
				DrawThumb(hdc);
			}
		}
		//snaps load
		if (i == 6 )
		{
			ZoneTexte.left += GetLenghtText(hdc,"Load snapshoot :.") + SelSnap * MENUHEIGHT;
			DrawRect(hdc,ZoneTexte.left+rc.left,ZoneTexte.top+rc.top,MENUHEIGHT,MENUHEIGHT);

			//display thumb in a corner
			if ((SelMenu == 6) && (bmpthumb))
			{
				DrawThumb(hdc);
			}
		}
	}

	SelectObject(hdc, hOldFont);
	DeleteObject(hFont);

	return TRUE;
}

int GetLenghtText(HDC hdc,char*s)
{
	RECT r = { 0, 0, 0, 0 };
	DrawText(hdc, s, strlen(s), &r, DT_CALCRECT);
	return r.right-r.left;
}

void DrawBox(HDC hdc, int x, int y,int w,int h,COLORREF c1,COLORREF c2)
{
	RECT rc;
	HBRUSH hbrush =  CreateSolidBrush(c1);
	HPEN hpen = CreatePen(PS_SOLID, 2, c2);
	HBRUSH hbrushOld = (HBRUSH)SelectObject(hdc, hbrush);
	HPEN hpenOld = (HPEN)SelectObject(hdc, hpen);

	rc.bottom=y+h;
	rc.top=y;
	rc.left=x;
	rc.right=x+w;

	//SetBkMode(hdc, TRANSPARENT);
	//SetDCPenColor(hdc, RGB(255, 0, 0));
    Rectangle(hdc, rc.left, rc.top, rc.right, rc.bottom);
	//FillRect(hdc, &rc, hbrush);

	SelectObject(hdc, hbrushOld);
	SelectObject(hdc, hpenOld);

	DeleteObject(hpen);
	DeleteObject(hbrush);

	/*
	SetBkMode(hDC, TRANSPARENT);
	FillRect(hDC, &rc, hBrush);
	Rectangle(hDC, rc.left, rc.top, rc.right, rc.bottom);
*/
}

void DrawRect(HDC hdc, int x, int y,int w,int h)
{
	RECT rc;
	HBRUSH hbrush =  (HBRUSH)GetStockObject(HOLLOW_BRUSH);
	HBRUSH hbrushOld = (HBRUSH)SelectObject(hdc, hbrush);

	HPEN hpen = CreatePen(PS_SOLID, 4, RGB(128, 0, 128));
	HPEN hpenOld = (HPEN)SelectObject(hdc, hpen);

	rc.bottom=y+h;
	rc.top=y;
	rc.left=x;
	rc.right=x+w;

	//FillRect(hdc, &rc, hbrush);  //Too poor performance
	Rectangle(hdc, rc.left, rc.top, rc.right, rc.bottom);

	SelectObject(hdc, hbrushOld);
	SelectObject(hdc, hpenOld);

	DeleteObject(hbrush);
	DeleteObject(hpen);
}

/*
void GetMediaName(void)
{
	char path[255];
	//Get name file of loaded media
	for (unsigned int i=0; i!=wxGetApp().m_Media.GetCount(); i++)
	{
		Media *pMedia = wxGetApp().m_Media[i];
		if (pMedia->GetMediaInserted())
		{
			path = pMedia->GetCurrentPath();
			int pos = path.rfind("#");
			if (pos > 0)
			{
				path = path.Left(pos);
			}
			wxFileName File(path);
			m_FileName = File.GetName();
			break;

		}
	}

	m_FileName = "test";
}
*/


int iStrInStr(char *scr,char *s)
{
	int len;
	unsigned int i;
	int j;
	char temp[MAX_PATH];
	BOOL find;

	len = strlen(s);
	
	find = FALSE;

	for(i = 0 ; i < strlen(scr) - len + 1; i++)
		{
			for(j=0; j<len; j++) temp[j] = scr[i+j];
			temp[len]='\0';
			if(!strcmp(s,temp)){find=TRUE;break;}
		}
	if(find)return i;
	else return -1;
}


//work for Game name (Disk 1 of 2) and Game name (Disk 1/2)
void GetDiskNumberInfo(int *number,int *max)
{
	int pos;
	char tmp[MAX_PATH];
	int FilenameLength;
	short ad = 0, ld = 0;
	int c;

	*number = 0;
	*max = 0;

	if (strcmp(LastOpenedRom,DriveAFilename) != 0)
	{
		SetInfoMessage("Sorry - Work only for Disk A");
		return;
	}

	strncpy(tmp,DriveAFilename,MAX_PATH);
	FilenameLength = strlen(tmp);

	if (FilenameLength == 0) return;

	pos = iStrInStr(DriveAFilename,"(Disk");
	if (pos == -1) return;

	while (pos < FilenameLength)
	{
		c = tmp[pos];
		if ((c >='0') && (c <= '9'))
		{
			if (ad == 0)
				ad = c - 48;
			else
				ld = c- 48;
		}
		pos +=1;

	}

#if 0
	if ( (tmp[pos+8] == 'o') && (tmp[pos+9] == 'f') )
	{
		ad = tmp[pos+6] - 48;
		ld = tmp[pos+11] - 48;
	}
	else if (tmp[pos+7] == '/')
	{
		ad = tmp[pos+6] - 48;
		ld = tmp[pos+8] - 48;
	}
#endif

	*number = ad;
	*max = ld;

	return;
}


void GetNextDisk(char * file,int disk)
{
	int pos;
	int FilenameLength;

	FilenameLength = strlen(file);

	if (FilenameLength == 0) return;

	pos = iStrInStr(file,"(Disk");
	if (pos == -1) return;

	file[pos+6] = disk + 48;

	return;
}